#include <bits/stdc++.h>

using namespace std;

using ll = long long;

int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);

    int n, m;
    cin >> n >> m;

    vector<pair<ll, ll>> redovi(n);
    vector<pair<ll, ll>> kolone(m);

    for(auto &z : redovi) cin >> z.first >> z.second;
    for(auto &z : kolone) cin >> z.first >> z.second;

    vector<int> redRedosled(n);
    iota(redRedosled.begin(), redRedosled.end(), 0);

    sort(redRedosled.begin(), redRedosled.end(), [&](int a, int b) {
         return redovi[a].first > redovi[b].first;
    });

    priority_queue<pair<ll, int>> pq;

    for(int i = 0; i < m; ++i) {
        pq.push({kolone[i].first, i});
    }

    map<pair<int, int>, ll> resenje;

    vector<ll> redSuma(n);
    vector<ll> kolonaSuma(m);
    priority_queue<pair<ll, int>> zaKasnije;


    for(auto z : redRedosled) {
        while(redSuma[z] < redovi[z].first && !pq.empty()) {
            auto naj = pq.top();
            pq.pop();
            ll uzmi = min(redovi[z].first - redSuma[z], naj.first);
            resenje[{z, naj.second}] += uzmi;
            redSuma[z] += uzmi;
            kolonaSuma[naj.second] += uzmi;
            naj.first -= uzmi;

            if(naj.first > 0) {
                pq.push(naj);
            } else {
                zaKasnije.push({kolone[naj.second].second - kolone[naj.second].first, naj.second});
            }
        }
    }

    sort(redRedosled.begin(), redRedosled.end(), [&](int a, int b) {
         return redovi[a].first - redSuma[a] > redovi[b].first - redSuma[b];
    });

    //u slucaju da postoji red takav da nije dobro popunjen
    for(auto z : redRedosled) {
        while(redSuma[z] < redovi[z].first && !zaKasnije.empty()) {
            auto naj = zaKasnije.top();
            zaKasnije.pop();
            ll uzmi = min(redovi[z].first - redSuma[z], naj.first);
            resenje[{z, naj.second}] += uzmi;
            redSuma[z] += uzmi;
            kolonaSuma[naj.second] += uzmi;
            naj.first -= uzmi;

            if(naj.first > 0) {
                zaKasnije.push(naj);
            }
        }
    }

    sort(redRedosled.begin(), redRedosled.end(), [&](int a, int b) {
         return redovi[a].second - redovi[a].first > redovi[b].second - redovi[b].first;
    });

    //u slucaju da postoji kolona takva da je nismo popunili
    for(auto z : redRedosled) {
        while(redSuma[z] < redovi[z].second && !pq.empty()) {
            auto naj = pq.top();
            pq.pop();
            ll uzmi = min(redovi[z].second - redSuma[z], naj.first);
            resenje[{z, naj.second}] += uzmi;
            redSuma[z] += uzmi;
            kolonaSuma[naj.second] += uzmi;
            naj.first -= uzmi;

            if(naj.first > 0) {
                pq.push(naj);
            } else {
                zaKasnije.push({kolone[naj.second].second - kolone[naj.second].first, naj.second});
            }
        }
    }

    sort(redRedosled.begin(), redRedosled.end(), [&](int a, int b) {
         return redovi[a].second - redovi[a].first > redovi[b].second - redovi[b].first;
    });

    for(auto z : redRedosled) {
        while(redSuma[z] < redovi[z].second && !zaKasnije.empty()) {
            auto naj = zaKasnije.top();
            zaKasnije.pop();
            ll uzmi = min(redovi[z].second - redSuma[z], naj.first);
            resenje[{z, naj.second}] += uzmi;
            redSuma[z] += uzmi;
            kolonaSuma[naj.second] += uzmi;
            naj.first -= uzmi;
        }
    }

    cout << resenje.size() << '\n';

    ll ukupno = 0;
    for(auto z : resenje) ukupno += z.second;
    cout << ukupno << '\n';

    for(auto z : resenje) {
        auto kor = z.first;
        ll odg = z.second;
        cout << kor.first + 1 << " " << kor.second + 1 << " " << odg << '\n';
    }
}